/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.graphics;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Iterator;
import org.stathissideris.ascii2image.core.ConversionOptions;
import org.stathissideris.ascii2image.core.Pair;
import org.stathissideris.ascii2image.graphics.BitmapRenderer;
import org.stathissideris.ascii2image.graphics.CompositeDiagramShape;
import org.stathissideris.ascii2image.graphics.CustomShapeDefinition;
import org.stathissideris.ascii2image.graphics.DiagramComponent;
import org.stathissideris.ascii2image.graphics.DiagramShape;
import org.stathissideris.ascii2image.graphics.DiagramText;
import org.stathissideris.ascii2image.graphics.FontMeasurer;
import org.stathissideris.ascii2image.graphics.ShapeEdge;
import org.stathissideris.ascii2image.graphics.ShapePoint;
import org.stathissideris.ascii2image.text.AbstractionGrid;
import org.stathissideris.ascii2image.text.CellSet;
import org.stathissideris.ascii2image.text.TextGrid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Diagram {
    private static final boolean DEBUG = false;
    private static final boolean VERBOSE_DEBUG = false;
    private ArrayList shapes = new ArrayList();
    private ArrayList compositeShapes = new ArrayList();
    private ArrayList textObjects = new ArrayList();
    private int width;
    private int height;
    private int cellWidth;
    private int cellHeight;

    public Diagram(TextGrid textGrid, ConversionOptions conversionOptions) {
        Object object;
        Object object2;
        Object object32;
        Object object42;
        ArrayList<CellSet> arrayList;
        this.cellWidth = conversionOptions.renderingOptions.getCellWidth();
        this.cellHeight = conversionOptions.renderingOptions.getCellHeight();
        this.width = textGrid.getWidth() * this.cellWidth;
        this.height = textGrid.getHeight() * this.cellHeight;
        TextGrid textGrid2 = new TextGrid(textGrid);
        textGrid2.replaceTypeOnLine();
        textGrid2.replacePointMarkersOnLine();
        int n = textGrid.getWidth();
        int n2 = textGrid.getHeight();
        AbstractionGrid abstractionGrid = new AbstractionGrid(textGrid2, textGrid2.getAllBoundaries());
        ArrayList arrayList2 = abstractionGrid.getDistinctShapes();
        ArrayList arrayList3 = new ArrayList();
        for (CellSet cellSet : arrayList2) {
            arrayList = new TextGrid(n * 3, n2 * 3);
            for (int i = 0; i < n2 * 3; ++i) {
                for (int j = 0; j < n * 3; ++j) {
                    if (!((TextGrid)((Object)arrayList)).isBlank(j, i)) continue;
                    Object object7 = new AbstractionGrid(textGrid2, cellSet).getCopyOfInternalBuffer();
                    Iterator iterator = object7;
                    iterator.getClass();
                    CellSet cellSet2 = ((TextGrid)object7).findBoundariesExpandingFrom(new TextGrid.Cell((TextGrid)((Object)iterator), j, i));
                    if (cellSet2.size() == 0) continue;
                    arrayList3.add(cellSet2.makeScaledOneThirdEquivalent());
                    Object object5 = object7 = new AbstractionGrid(textGrid2, cellSet).getCopyOfInternalBuffer();
                    object5.getClass();
                    CellSet cellSet3 = ((TextGrid)object7).fillContinuousArea(new TextGrid.Cell((TextGrid)object5, j, i), '*');
                    ((TextGrid)((Object)arrayList)).fillCellsWith(cellSet3, '*');
                    ((TextGrid)((Object)arrayList)).fillCellsWith(cellSet2, '-');
                }
            }
        }
        arrayList3 = CellSet.removeDuplicateSets(arrayList3);
        int n3 = arrayList3.size();
        arrayList3 = CellSet.removeDuplicateSets(arrayList3);
        arrayList = new ArrayList();
        ArrayList<CellSet> arrayList4 = new ArrayList<CellSet>();
        ArrayList<CellSet> arrayList5 = new ArrayList<CellSet>();
        for (CellSet cellSet2 : arrayList3) {
            int n4 = cellSet2.getType(textGrid2);
            if (n4 == 0) {
                arrayList4.add(cellSet2);
                continue;
            }
            if (n4 == 1) {
                arrayList.add(cellSet2);
                continue;
            }
            if (n4 != 2) continue;
            arrayList5.add(cellSet2);
        }
        boolean bl = false;
        if (arrayList5.size() > 0 && arrayList4.size() > 0) {
            bl = true;
            for (CellSet cellSet : arrayList5) {
                for (CellSet iterable2 : arrayList4) {
                    cellSet.subtractSet(iterable2);
                }
                if (cellSet.getType(textGrid2) != 1) continue;
                arrayList3.remove(cellSet);
                arrayList3.addAll(cellSet.breakIntoDistinctBoundaries(textGrid2));
            }
        } else if (arrayList5.size() > 0 && arrayList4.size() == 0) {
            bl = true;
            for (CellSet cellSet : arrayList5) {
                arrayList3.remove(cellSet);
                arrayList3.addAll(cellSet.breakTrulyMixedBoundaries(textGrid2));
            }
        }
        if (bl) {
            arrayList = new ArrayList<CellSet>();
            arrayList4 = new ArrayList();
            arrayList5 = new ArrayList();
            for (CellSet cellSet : arrayList3) {
                int n5 = cellSet.getType(textGrid2);
                if (n5 == 0) {
                    arrayList4.add(cellSet);
                    continue;
                }
                if (n5 == 1) {
                    arrayList.add(cellSet);
                    continue;
                }
                if (n5 != 2) continue;
                arrayList5.add(cellSet);
            }
        }
        boolean bl2 = this.removeObsoleteShapes(textGrid2, arrayList4);
        boolean bl3 = false;
        if (conversionOptions.processingOptions.areAllCornersRound()) {
            bl3 = true;
        }
        ArrayList<DiagramComponent> arrayList6 = new ArrayList<DiagramComponent>();
        for (CellSet cellSet : arrayList4) {
            DiagramComponent diagramComponent = DiagramComponent.createClosedFromBoundaryCells(textGrid2, cellSet, this.cellWidth, this.cellHeight, bl3);
            if (diagramComponent == null) continue;
            if (diagramComponent instanceof DiagramShape) {
                this.addToShapes((DiagramShape)diagramComponent);
                arrayList6.add(diagramComponent);
                continue;
            }
            if (!(diagramComponent instanceof CompositeDiagramShape)) continue;
            this.addToCompositeShapes((CompositeDiagramShape)diagramComponent);
        }
        if (conversionOptions.processingOptions.performSeparationOfCommonEdges()) {
            this.separateCommonEdges(arrayList6);
        }
        for (CellSet cellSet : arrayList) {
            if (cellSet.size() == 1) {
                DiagramShape diagramShape;
                TextGrid.Cell cell = cellSet.getFirst();
                if (textGrid.cellContainsDashedLineChar(cell) || (diagramShape = DiagramShape.createSmallLine(textGrid2, cell, this.cellWidth, this.cellHeight)) == null) continue;
                this.addToShapes(diagramShape);
                diagramShape.connectEndsToAnchors(textGrid2, this);
                continue;
            }
            DiagramComponent diagramComponent = CompositeDiagramShape.createOpenFromBoundaryCells(textGrid2, cellSet, this.cellWidth, this.cellHeight, bl3);
            if (diagramComponent == null) continue;
            if (diagramComponent instanceof CompositeDiagramShape) {
                this.addToCompositeShapes((CompositeDiagramShape)diagramComponent);
                ((CompositeDiagramShape)diagramComponent).connectEndsToAnchors(textGrid2, this);
                continue;
            }
            if (!(diagramComponent instanceof DiagramShape)) continue;
            this.addToShapes((DiagramShape)diagramComponent);
            ((DiagramShape)diagramComponent).connectEndsToAnchors(textGrid2, this);
            ((DiagramShape)diagramComponent).moveEndsToCellEdges(textGrid, this);
        }
        for (TextGrid.CellColorPair cellColorPair : textGrid.findColorCodes()) {
            ShapePoint shapePoint = new ShapePoint(this.getCellMidX(cellColorPair.cell), this.getCellMidY(cellColorPair.cell));
            for (Object object42 : this.getShapes()) {
                if (!((DiagramShape)object42).contains(shapePoint)) continue;
                ((DiagramShape)object42).setFillColor(cellColorPair.color);
            }
        }
        for (TextGrid.CellTagPair cellTagPair : textGrid.findMarkupTags()) {
            Object object6 = new ShapePoint(this.getCellMidX(cellTagPair.cell), this.getCellMidY(cellTagPair.cell));
            object42 = null;
            for (Object object32 : this.getShapes()) {
                if (!((DiagramShape)object32).contains((ShapePoint)object6)) continue;
                if (object42 == null) {
                    object42 = object32;
                    continue;
                }
                if (!((DiagramShape)object32).isSmallerThan((DiagramShape)object42)) continue;
                object42 = object32;
            }
            if (object42 == null) continue;
            if (cellTagPair.tag.equals("d")) {
                object32 = conversionOptions.processingOptions.getFromCustomShapes("d");
                if (object32 == null) {
                    ((DiagramShape)object42).setType(3);
                    continue;
                }
                ((DiagramShape)object42).setType(9999);
                ((DiagramShape)object42).setDefinition((CustomShapeDefinition)object32);
                continue;
            }
            if (cellTagPair.tag.equals("s")) {
                object32 = conversionOptions.processingOptions.getFromCustomShapes("s");
                if (object32 == null) {
                    ((DiagramShape)object42).setType(4);
                    continue;
                }
                ((DiagramShape)object42).setType(9999);
                ((DiagramShape)object42).setDefinition((CustomShapeDefinition)object32);
                continue;
            }
            if (cellTagPair.tag.equals("io")) {
                object32 = conversionOptions.processingOptions.getFromCustomShapes("io");
                if (object32 == null) {
                    ((DiagramShape)object42).setType(5);
                    continue;
                }
                ((DiagramShape)object42).setType(9999);
                ((DiagramShape)object42).setDefinition((CustomShapeDefinition)object32);
                continue;
            }
            if (cellTagPair.tag.equals("c")) {
                object32 = conversionOptions.processingOptions.getFromCustomShapes("c");
                if (object32 == null) {
                    ((DiagramShape)object42).setType(6);
                    continue;
                }
                ((DiagramShape)object42).setType(9999);
                ((DiagramShape)object42).setDefinition((CustomShapeDefinition)object32);
                continue;
            }
            if (cellTagPair.tag.equals("mo")) {
                object32 = conversionOptions.processingOptions.getFromCustomShapes("mo");
                if (object32 == null) {
                    ((DiagramShape)object42).setType(7);
                    continue;
                }
                ((DiagramShape)object42).setType(9999);
                ((DiagramShape)object42).setDefinition((CustomShapeDefinition)object32);
                continue;
            }
            if (cellTagPair.tag.equals("tr")) {
                object32 = conversionOptions.processingOptions.getFromCustomShapes("tr");
                if (object32 == null) {
                    ((DiagramShape)object42).setType(8);
                    continue;
                }
                ((DiagramShape)object42).setType(9999);
                ((DiagramShape)object42).setDefinition((CustomShapeDefinition)object32);
                continue;
            }
            if (cellTagPair.tag.equals("o")) {
                object32 = conversionOptions.processingOptions.getFromCustomShapes("o");
                if (object32 == null) {
                    ((DiagramShape)object42).setType(9);
                    continue;
                }
                ((DiagramShape)object42).setType(9999);
                ((DiagramShape)object42).setDefinition((CustomShapeDefinition)object32);
                continue;
            }
            object32 = conversionOptions.processingOptions.getFromCustomShapes(cellTagPair.tag);
            ((DiagramShape)object42).setType(9999);
            ((DiagramShape)object42).setDefinition((CustomShapeDefinition)object32);
        }
        for (Object object6 : textGrid2.findArrowheads()) {
            object42 = DiagramShape.createArrowhead(textGrid2, object6, this.cellWidth, this.cellHeight);
            if (object42 != null) {
                this.addToShapes((DiagramShape)object42);
                continue;
            }
            System.err.println("Could not create arrowhead shape. Unexpected error.");
        }
        for (Object object42 : textGrid.getPointMarkersOnLine()) {
            object2 = new DiagramShape();
            ((DiagramShape)object2).addToPoints(new ShapePoint(this.getCellMidX((TextGrid.Cell)object42), this.getCellMidY((TextGrid.Cell)object42)));
            ((DiagramShape)object2).setType(2);
            ((DiagramShape)object2).setFillColor(Color.white);
            this.shapes.add(object2);
        }
        this.removeDuplicateShapes();
        textGrid2 = new TextGrid(textGrid);
        textGrid2.removeNonText();
        object42 = new TextGrid(textGrid2);
        object2 = ((TextGrid)object42).getAllBlanksBetweenCharacters();
        ((TextGrid)object42).fillCellsWith((Iterable)object2, '|');
        object32 = ((TextGrid)object42).getAllNonBlank();
        ArrayList arrayList7 = ((CellSet)object32).breakIntoDistinctBoundaries();
        Font font = FontMeasurer.instance().getFontFor(this.cellHeight);
        for (Iterator iterator : arrayList7) {
            Object object7 = new TextGrid(n, n2);
            textGrid2.copyCellsTo((CellSet)((Object)iterator), (TextGrid)object7);
            object = ((TextGrid)object7).findStrings();
            Object object8 = ((ArrayList)object).iterator();
            while (object8.hasNext()) {
                DiagramText diagramText;
                Object object9 = (TextGrid.CellStringPair)object8.next();
                TextGrid.Cell cell = ((TextGrid.CellStringPair)object9).cell;
                String string = ((TextGrid.CellStringPair)object9).string;
                Object object10 = object7;
                object10.getClass();
                TextGrid.Cell cell2 = new TextGrid.Cell((TextGrid)object10, cell.x + string.length() - 1, cell.y);
                int n4 = this.getCellMinX(cell);
                int n5 = this.getCellMaxY(cell);
                int n6 = this.getCellMaxX(cell2);
                if (FontMeasurer.instance().getWidthFor(string, font) > n6 - n4) {
                    Font font2 = FontMeasurer.instance().getFontFor(n6 - n4, string);
                    diagramText = new DiagramText(n4, n5, string, font2);
                } else {
                    diagramText = new DiagramText(n4, n5, string, font);
                }
                diagramText.centerVerticallyBetween(this.getCellMinY(cell), this.getCellMaxY(cell));
                int n7 = ((TextGrid)object7).otherStringsStartInTheSameColumn(cell);
                int n8 = ((TextGrid)object7).otherStringsEndInTheSameColumn(cell2);
                if (0 == n7 && 0 == n8) {
                    diagramText.centerHorizontallyBetween(n4, n6);
                } else if (n8 > 0 && n7 == 0) {
                    diagramText.alignRightEdgeTo(n6);
                } else if (n8 > 0 && n7 > 0) {
                    if (n8 > n7) {
                        diagramText.alignRightEdgeTo(n6);
                    } else if (n8 == n7) {
                        diagramText.centerHorizontallyBetween(n4, n6);
                    }
                }
                this.addToTextObjects(diagramText);
            }
        }
        for (Object object7 : this.getAllDiagramShapes()) {
            object = ((DiagramShape)object7).getFillColor();
            if (!((DiagramShape)object7).isClosed() || ((DiagramShape)object7).getType() == 1 || object == null || !BitmapRenderer.isColorDark((Color)object)) continue;
            for (Object object9 : this.getTextObjects()) {
                if (!((DiagramShape)object7).intersects(((DiagramText)object9).getBounds())) continue;
                ((DiagramText)object9).setColor(Color.white);
            }
        }
        for (Object object7 : this.getAllDiagramShapes()) {
            if (((DiagramShape)object7).getType() != 9999) continue;
            for (Object object8 : this.getTextObjects()) {
                ((DiagramText)object8).setHasOutline(true);
                ((DiagramText)object8).setColor(DiagramText.DEFAULT_COLOR);
            }
        }
    }

    public ArrayList getAllDiagramShapes() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getShapes());
        for (CompositeDiagramShape compositeDiagramShape : this.getCompositeShapes()) {
            arrayList.addAll(compositeDiagramShape.getShapes());
        }
        return arrayList;
    }

    private boolean removeObsoleteShapes(TextGrid textGrid, ArrayList<CellSet> arrayList) {
        Iterable<TextGrid.Cell> iterable2;
        boolean bl = false;
        ArrayList<CellSet> arrayList2 = new ArrayList<CellSet>();
        for (CellSet cellSet : arrayList) {
            CellSet iterable22 = cellSet.getFilledEquivalent(textGrid);
            if (iterable22 == null) {
                return false;
            }
            arrayList2.add(iterable22);
        }
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        for (Iterable<TextGrid.Cell> iterable2 : arrayList2) {
            Iterable<TextGrid.Cell> iterable32;
            ArrayList<Iterable<TextGrid.Cell>> cellSet = new ArrayList<Iterable<TextGrid.Cell>>();
            cellSet.add(iterable2);
            for (Iterable<TextGrid.Cell> iterable32 : arrayList2) {
                if (iterable2 == iterable32 || !((CellSet)iterable2).hasCommonCells((CellSet)iterable32)) continue;
                cellSet.add(iterable32);
            }
            if (cellSet.size() == 2) continue;
            iterable32 = iterable2;
            for (CellSet cellSet2 : cellSet) {
                if (cellSet2.size() <= ((CellSet)iterable32).size()) continue;
                iterable32 = cellSet2;
            }
            cellSet.remove(iterable32);
            TextGrid textGrid2 = new TextGrid(((CellSet)iterable32).getMaxX() + 2, ((CellSet)iterable32).getMaxY() + 2);
            CellSet cellSet3 = new CellSet();
            for (CellSet cellSet4 : cellSet) {
                textGrid2.fillCellsWith(cellSet4, '*');
            }
            TextGrid textGrid3 = new TextGrid(((CellSet)iterable32).getMaxX() + 2, ((CellSet)iterable32).getMaxY() + 2);
            textGrid3.fillCellsWith(iterable32, '*');
            int n = arrayList2.indexOf(iterable32);
            if (!textGrid3.equals(textGrid2) || arrayList3.contains(new Integer(n))) continue;
            arrayList3.add(new Integer(n));
        }
        iterable2 = new ArrayList();
        Iterator<CellSet> iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)((Object)iterator.next());
            ((ArrayList)iterable2).add((CellSet)arrayList.get(n));
        }
        for (CellSet cellSet : iterable2) {
            bl = true;
            arrayList.remove(cellSet);
        }
        return bl;
    }

    public float getMinimumOfCellDimension() {
        return Math.min(this.getCellWidth(), this.getCellHeight());
    }

    private void separateCommonEdges(ArrayList arrayList) {
        Object object;
        Object object22;
        float f = this.getMinimumOfCellDimension() / 5.0f;
        ArrayList arrayList2 = new ArrayList();
        for (Object object22 : arrayList) {
            arrayList2.addAll(((DiagramShape)object22).getEdges());
        }
        object22 = new ArrayList();
        Iterator iterator = arrayList2.iterator();
        int n = 1;
        while (iterator.hasNext()) {
            object = (ShapeEdge)iterator.next();
            for (int i = n; i < arrayList2.size(); ++i) {
                ShapeEdge shapeEdge = (ShapeEdge)arrayList2.get(i);
                if (!((ShapeEdge)object).touchesWith(shapeEdge)) continue;
                ((ArrayList)object22).add(new Pair<Object, ShapeEdge>(object, shapeEdge));
            }
            ++n;
        }
        object = new ArrayList();
        iterator = ((ArrayList)object22).iterator();
        while (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            if (!((ArrayList)object).contains(pair.first)) {
                ((ShapeEdge)pair.first).moveInwardsBy(f);
                ((ArrayList)object).add(pair.first);
            }
            if (((ArrayList)object).contains(pair.second)) continue;
            ((ShapeEdge)pair.second).moveInwardsBy(f);
            ((ArrayList)object).add(pair.second);
        }
    }

    private void removeDuplicateShapes() {
        ArrayList<DiagramShape> arrayList = new ArrayList<DiagramShape>();
        Iterator iterator = this.getShapesIterator();
        while (iterator.hasNext()) {
            DiagramShape diagramShape = (DiagramShape)iterator.next();
            boolean bl = true;
            for (DiagramShape diagramShape2 : arrayList) {
                if (!diagramShape.equals(diagramShape2)) continue;
                bl = false;
            }
            if (!bl) continue;
            arrayList.add(diagramShape);
        }
        this.shapes.clear();
        this.shapes.addAll(arrayList);
    }

    private void addToTextObjects(DiagramText diagramText) {
        this.textObjects.add(diagramText);
    }

    private void addToCompositeShapes(CompositeDiagramShape compositeDiagramShape) {
        this.compositeShapes.add(compositeDiagramShape);
    }

    private void addToShapes(DiagramShape diagramShape) {
        this.shapes.add(diagramShape);
    }

    public Iterator getShapesIterator() {
        return this.shapes.iterator();
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getCellWidth() {
        return this.cellWidth;
    }

    public int getCellHeight() {
        return this.cellHeight;
    }

    public ArrayList getCompositeShapes() {
        return this.compositeShapes;
    }

    public ArrayList getShapes() {
        return this.shapes;
    }

    public int getCellMinX(TextGrid.Cell cell) {
        return Diagram.getCellMinX(cell, this.cellWidth);
    }

    public static int getCellMinX(TextGrid.Cell cell, int n) {
        return cell.x * n;
    }

    public int getCellMidX(TextGrid.Cell cell) {
        return Diagram.getCellMidX(cell, this.cellWidth);
    }

    public static int getCellMidX(TextGrid.Cell cell, int n) {
        return cell.x * n + n / 2;
    }

    public int getCellMaxX(TextGrid.Cell cell) {
        return Diagram.getCellMaxX(cell, this.cellWidth);
    }

    public static int getCellMaxX(TextGrid.Cell cell, int n) {
        return cell.x * n + n;
    }

    public int getCellMinY(TextGrid.Cell cell) {
        return Diagram.getCellMinY(cell, this.cellHeight);
    }

    public static int getCellMinY(TextGrid.Cell cell, int n) {
        return cell.y * n;
    }

    public int getCellMidY(TextGrid.Cell cell) {
        return Diagram.getCellMidY(cell, this.cellHeight);
    }

    public static int getCellMidY(TextGrid.Cell cell, int n) {
        return cell.y * n + n / 2;
    }

    public int getCellMaxY(TextGrid.Cell cell) {
        return Diagram.getCellMaxY(cell, this.cellHeight);
    }

    public static int getCellMaxY(TextGrid.Cell cell, int n) {
        return cell.y * n + n;
    }

    public TextGrid.Cell getCellFor(ShapePoint shapePoint) {
        TextGrid textGrid;
        if (shapePoint == null) {
            throw new IllegalArgumentException("ShapePoint cannot be null");
        }
        TextGrid textGrid2 = textGrid = new TextGrid();
        textGrid2.getClass();
        return new TextGrid.Cell(textGrid2, (int)shapePoint.x / this.cellWidth, (int)shapePoint.y / this.cellHeight);
    }

    public ArrayList getTextObjects() {
        return this.textObjects;
    }
}

